/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.Key;
import java.lang.reflect.Type;
import java.util.Map;
import org.weakref.jmx.guice.ObjectNameFunction;
import org.weakref.jmx.internal.guava.reflect.TypeParameter;
import org.weakref.jmx.internal.guava.reflect.TypeToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapMapping<K, V> {
    private final ObjectNameFunction<Map.Entry<K, V>> objectNameFunction;
    private final Class<K> keyClass;
    private final Class<V> valueClass;

    MapMapping(Class<K> keyClass, Class<V> valueClass, ObjectNameFunction<Map.Entry<K, V>> objectNameFunction) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.objectNameFunction = objectNameFunction;
    }

    public ObjectNameFunction<Map.Entry<K, V>> getObjectNameFunction() {
        return this.objectNameFunction;
    }

    public Key<Map<K, V>> getKey() {
        return Key.get(MapMapping.mapOf(this.keyClass, this.valueClass));
    }

    private static <K, V> Type mapOf(Class<K> keyClass, Class<V> valueClass) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of(keyClass)).where(new TypeParameter<V>(){}, TypeToken.of(valueClass)).getType();
    }
}

