/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.guice.MapMapping;
import org.weakref.jmx.guice.Mapping;
import org.weakref.jmx.guice.ObjectNameFunction;
import org.weakref.jmx.guice.SetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GuiceMBeanExporter {
    @Inject
    public GuiceMBeanExporter(Set<Mapping> mappings, Set<SetMapping<?>> setMappings, Set<MapMapping<?, ?>> mapMappings, MBeanExporter exporter, Injector injector) {
        this.export(mappings, exporter, injector);
        this.exportSets(setMappings, exporter, injector);
        this.exportMaps(mapMappings, exporter, injector);
    }

    private <K, V> void exportMaps(Set<MapMapping<K, V>> mapMappings, MBeanExporter exporter, Injector injector) {
        for (MapMapping<K, V> mapping : mapMappings) {
            ObjectNameFunction<Map.Entry<K, V>> namingFunction = mapping.getObjectNameFunction();
            Map<K, V> map = injector.getInstance(mapping.getKey());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                ObjectName name = namingFunction.name(entry);
                exporter.export(name, entry.getValue());
            }
        }
    }

    private <T> void exportSets(Set<SetMapping<T>> setMappings, MBeanExporter exporter, Injector injector) {
        for (SetMapping<T> mapping : setMappings) {
            ObjectNameFunction<T> objectNameFunction = mapping.getObjectNameFunction();
            Set<T> set = injector.getInstance(mapping.getKey());
            for (T instance : set) {
                ObjectName name = objectNameFunction.name(instance);
                exporter.export(name, instance);
            }
        }
    }

    private void export(Set<Mapping> mappings, MBeanExporter exporter, Injector injector) {
        for (Mapping mapping : mappings) {
            exporter.export(mapping.getName(), injector.getInstance(mapping.getKey()));
        }
    }
}

