/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;

public class Reflection {
    public static Class<?> getClass(ClassLoader classLoader, String className) throws Exception {
        return ClassUtils.getClass(classLoader, className, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAnnotationValue(Annotation annotation, String name) throws IllegalAccessException, InvocationTargetException {
        Method valueMethod;
        try {
            valueMethod = annotation.annotationType().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        boolean mustUnset = Reflection.setAccessible(valueMethod, true);
        try {
            Object object = valueMethod.invoke((Object)annotation, new Object[0]);
            return object;
        }
        finally {
            if (mustUnset) {
                Reflection.setAccessible(valueMethod, false);
            }
        }
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? clazz.getClassLoader() : cl;
    }

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... parameters) {
        try {
            return clazz.getDeclaredConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameters) {
        try {
            return clazz.getDeclaredMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        return clazz.getDeclaredConstructors();
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T> T newInstance(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot instantiate : " + cls, ex);
        }
    }

    public static boolean setAccessible(AccessibleObject o, boolean accessible) {
        if (o == null || o.isAccessible() == accessible) {
            return false;
        }
        if (!accessible && System.getSecurityManager() == null) {
            return false;
        }
        Member m = (Member)((Object)o);
        if (Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
            return false;
        }
        o.setAccessible(accessible);
        return true;
    }
}

