/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.model;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bval.model.Validation;
import org.apache.commons.lang3.ArrayUtils;

public abstract class FeaturesCapable
implements Serializable {
    private static final long serialVersionUID = -4045110242904814218L;
    private ConcurrentMap<String, Object> features = this.createFeaturesMap();
    private Validation[] validations = new Validation[0];

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public <T> T getFeature(String key) {
        return (T)this.getFeature(key, null);
    }

    public <T> T getFeature(String key, T defaultValue) {
        Object value = this.features.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public <T> void putFeature(String key, T value) {
        this.features.put(key, value);
    }

    public <T> T initFeature(String key, T value) {
        Object faster = this.features.putIfAbsent(key, value);
        return (T)(faster == null ? value : faster);
    }

    public <T extends FeaturesCapable> T copy() {
        try {
            FeaturesCapable self = (FeaturesCapable)this.clone();
            this.copyInto(self);
            return (T)self;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("cannot clone() " + this, e);
        }
    }

    protected void copyInto(FeaturesCapable target) {
        target.features = target.createFeaturesMap();
        target.features.putAll(this.features);
        target.validations = ArrayUtils.clone(this.validations);
    }

    public Validation[] getValidations() {
        return ArrayUtils.clone(this.validations);
    }

    public void setValidations(Validation[] validations) {
        this.validations = ArrayUtils.clone(validations);
    }

    public void addValidation(Validation validation) {
        if (this.validations == null) {
            this.validations = new Validation[]{validation};
        } else {
            Validation[] newValidations = new Validation[this.validations.length + 1];
            System.arraycopy(this.validations, 0, newValidations, 0, this.validations.length);
            newValidations[this.validations.length] = validation;
            this.validations = newValidations;
        }
    }

    public boolean hasValidation(Validation aValidation) {
        if (this.validations == null) {
            return false;
        }
        for (Validation validation : this.validations) {
            if (!validation.equals(aValidation)) continue;
            return true;
        }
        return false;
    }

    protected ConcurrentMap<String, Object> createFeaturesMap() {
        return new ConcurrentHashMap<String, Object>();
    }
}

