/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ValidationException;
import org.apache.bval.cdi.BValExtension;

public class DefaultConstraintValidatorFactory
implements ConstraintValidatorFactory,
Closeable {
    private final Collection<BValExtension.Releasable<?>> releasables = new CopyOnWriteArrayList();
    private Boolean useCdi = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> constraintClass) {
        if (this.useCdi == null) {
            DefaultConstraintValidatorFactory defaultConstraintValidatorFactory = this;
            synchronized (defaultConstraintValidatorFactory) {
                if (this.useCdi == null) {
                    try {
                        this.useCdi = BValExtension.getBeanManager() != null;
                    }
                    catch (NoClassDefFoundError error) {
                        this.useCdi = Boolean.FALSE;
                    }
                    catch (Exception e) {
                        this.useCdi = Boolean.FALSE;
                    }
                }
            }
        }
        try {
            if (this.useCdi.booleanValue()) {
                try {
                    BValExtension.Releasable<T> instance = BValExtension.inject(constraintClass);
                    if (instance != null) {
                        this.releasables.add(instance);
                        return (T)((ConstraintValidator)instance.getInstance());
                    }
                    throw new IllegalStateException("Can't create " + constraintClass.getName());
                }
                catch (Exception e) {
                    return (T)((ConstraintValidator)constraintClass.newInstance());
                }
                catch (NoClassDefFoundError error) {
                    return (T)((ConstraintValidator)constraintClass.newInstance());
                }
            }
            return (T)((ConstraintValidator)constraintClass.newInstance());
        }
        catch (Exception ex) {
            throw new ValidationException("Cannot instantiate : " + constraintClass, ex);
        }
    }

    @Override
    public void releaseInstance(ConstraintValidator<?, ?> instance) {
    }

    @Override
    public void close() throws IOException {
        for (BValExtension.Releasable<?> releasable : this.releasables) {
            this.releaseInstance((ConstraintValidator)ConstraintValidator.class.cast(releasable.getInstance()));
            releasable.release();
        }
        this.releasables.clear();
    }
}

