/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import io.airlift.log.StaticFormatter;
import io.airlift.units.DataSize;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

final class RollingFileHandler
extends Handler {
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final FileSize BUFFER_SIZE_IN_BYTES = new FileSize(new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes());
    private final AsyncAppenderBase<String> asyncAppender;

    public RollingFileHandler(String filename, int maxHistory, long maxSizeInBytes) {
        this.setFormatter(new StaticFormatter());
        ContextBase context = new ContextBase();
        this.recoverTempFiles(filename);
        RollingFileAppender<String> fileAppender = new RollingFileAppender<String>();
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        SizeAndTimeBasedFNATP triggeringPolicy = new SizeAndTimeBasedFNATP();
        rollingPolicy.setContext(context);
        rollingPolicy.setFileNamePattern(filename + "-%d{yyyy-MM-dd}.%i.log.gz");
        rollingPolicy.setMaxHistory(maxHistory);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy(triggeringPolicy);
        rollingPolicy.setParent(fileAppender);
        triggeringPolicy.setContext(context);
        triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
        triggeringPolicy.setMaxFileSize(new FileSize(maxSizeInBytes));
        fileAppender.setContext(context);
        fileAppender.setFile(filename);
        fileAppender.setAppend(true);
        fileAppender.setBufferSize(BUFFER_SIZE_IN_BYTES);
        fileAppender.setEncoder(new StringEncoder());
        fileAppender.setRollingPolicy(rollingPolicy);
        this.asyncAppender = new AsyncAppenderBase();
        this.asyncAppender.setContext(context);
        this.asyncAppender.addAppender(fileAppender);
        rollingPolicy.start();
        triggeringPolicy.start();
        fileAppender.start();
        this.asyncAppender.start();
    }

    @Override
    public void publish(LogRecord record) {
        String message;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            message = this.getFormatter().format(record);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        try {
            this.asyncAppender.doAppend(message);
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        try {
            this.asyncAppender.stop();
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
    }

    private void recoverTempFiles(String logPath) {
        File logPathFile = new File(logPath).getParentFile();
        File[] tempFiles = logPathFile.listFiles((dir, name) -> name.endsWith(TEMP_FILE_EXTENSION));
        if (tempFiles == null) {
            return;
        }
        for (File tempFile : tempFiles) {
            String newName = tempFile.getName().substring(0, tempFile.getName().length() - TEMP_FILE_EXTENSION.length());
            File newFile = new File(tempFile.getParent(), newName + LOG_FILE_EXTENSION);
            if (tempFile.renameTo(newFile)) continue;
            this.reportError(String.format("Could not rename temp file [%s] to [%s]", tempFile, newFile), null, 4);
        }
    }

    private static final class StringEncoder
    extends EncoderBase<String> {
        private static final byte[] EMPTY_BYTES = new byte[0];

        private StringEncoder() {
        }

        @Override
        public byte[] headerBytes() {
            return EMPTY_BYTES;
        }

        @Override
        public byte[] encode(String event) {
            return event.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public byte[] footerBytes() {
            return EMPTY_BYTES;
        }
    }
}

