/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public final class ExtendedSettableFuture<V>
extends AbstractFuture<V> {
    public static <V> ExtendedSettableFuture<V> create() {
        return new ExtendedSettableFuture<V>();
    }

    private ExtendedSettableFuture() {
    }

    @Override
    public boolean set(@Nullable V value) {
        return super.set(value);
    }

    @Override
    public boolean setException(Throwable throwable) {
        return super.setException(throwable);
    }

    public void setAsync(ListenableFuture<? extends V> delegate) {
        delegate.addListener(() -> {
            if (super.isDone()) {
                return;
            }
            try {
                this.set(Futures.getDone(delegate));
            }
            catch (ExecutionException e) {
                this.setException(e.getCause());
            }
            catch (Error | RuntimeException e) {
                this.setException(e);
            }
        }, MoreExecutors.directExecutor());
        super.addListener(() -> {
            if (super.isCancelled()) {
                delegate.cancel(super.wasInterrupted());
            }
        }, MoreExecutors.directExecutor());
    }

    @VisibleForTesting
    boolean checkWasInterrupted() {
        return super.wasInterrupted();
    }
}

