/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.net.HostAndPort;
import java.io.IOException;

public class HostAndPortDeserializer
extends FromStringDeserializer<HostAndPort> {
    private static final long serialVersionUID = 1L;
    public static final HostAndPortDeserializer std = new HostAndPortDeserializer();

    public HostAndPortDeserializer() {
        super(HostAndPort.class);
    }

    @Override
    public HostAndPort deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            JsonNode root = (JsonNode)jp.readValueAsTree();
            String host = root.path("hostText").asText();
            JsonNode n = root.get("port");
            if (n == null) {
                return HostAndPort.fromString(host);
            }
            return HostAndPort.fromParts(host, n.asInt());
        }
        return (HostAndPort)super.deserialize(jp, ctxt);
    }

    @Override
    protected HostAndPort _deserialize(String value, DeserializationContext ctxt) throws IOException {
        return HostAndPort.fromString(value);
    }
}

