/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.util;

import com.facebook.presto.sql.tree.Node;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.Objects;
import java.util.stream.Stream;

public final class AstUtils {
    public static boolean nodeContains(Node node, Node subNode) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(subNode, "subNode is null");
        return AstUtils.preOrder(node).anyMatch(childNode -> childNode == subNode);
    }

    public static Stream<Node> preOrder(Node node) {
        return Streams.stream(Traverser.forTree(Node::getChildren).depthFirstPreOrder(Objects.requireNonNull(node, "node is null")));
    }

    private AstUtils() {
    }
}

