/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Relation;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Unnest
extends Relation {
    private final List<Expression> expressions;
    private final boolean withOrdinality;

    public Unnest(List<Expression> expressions, boolean withOrdinality) {
        this(Optional.empty(), expressions, withOrdinality);
    }

    public Unnest(NodeLocation location, List<Expression> expressions, boolean withOrdinality) {
        this(Optional.of(location), expressions, withOrdinality);
    }

    private Unnest(Optional<NodeLocation> location, List<Expression> expressions, boolean withOrdinality) {
        super(location);
        Objects.requireNonNull(expressions, "expressions is null");
        this.expressions = ImmutableList.copyOf(expressions);
        this.withOrdinality = withOrdinality;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public boolean isWithOrdinality() {
        return this.withOrdinality;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnnest(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.expressions;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("expressions", this.expressions).add("withOrdinality", this.withOrdinality).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expressions, this.withOrdinality);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Unnest other = (Unnest)obj;
        return Objects.equals(this.expressions, other.expressions) && this.withOrdinality == other.withOrdinality;
    }
}

