/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.NodeLocation;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Optional;

public class StringLiteral
extends Literal {
    private final String value;
    private final Slice slice;

    public StringLiteral(String value) {
        this(Optional.empty(), value);
    }

    public StringLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    private StringLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        this.value = value;
        this.slice = Slices.utf8Slice(value);
    }

    public String getValue() {
        return this.value;
    }

    public Slice getSlice() {
        return this.slice;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitStringLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLiteral that = (StringLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

