/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.TransactionMode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class StartTransaction
extends Statement {
    private final List<TransactionMode> transactionModes;

    public StartTransaction(List<TransactionMode> transactionModes) {
        this(Optional.empty(), transactionModes);
    }

    public StartTransaction(NodeLocation location, List<TransactionMode> transactionModes) {
        this(Optional.of(location), transactionModes);
    }

    private StartTransaction(Optional<NodeLocation> location, List<TransactionMode> transactionModes) {
        super(location);
        this.transactionModes = ImmutableList.copyOf((Collection)Objects.requireNonNull(transactionModes, "transactionModes is null"));
    }

    public List<TransactionMode> getTransactionModes() {
        return this.transactionModes;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitStartTransaction(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.transactionModes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.transactionModes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StartTransaction other = (StartTransaction)obj;
        return Objects.equals(this.transactionModes, other.transactionModes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("transactionModes", this.transactionModes).toString();
    }
}

