/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowGrants
extends Statement {
    private final boolean table;
    private final Optional<QualifiedName> tableName;

    public ShowGrants(boolean table, Optional<QualifiedName> tableName) {
        this(Optional.empty(), table, tableName);
    }

    public ShowGrants(NodeLocation location, boolean table, Optional<QualifiedName> tableName) {
        this(Optional.of(location), table, tableName);
    }

    public ShowGrants(Optional<NodeLocation> location, boolean table, Optional<QualifiedName> tableName) {
        super(location);
        Objects.requireNonNull(tableName, "tableName is null");
        this.table = table;
        this.tableName = tableName;
    }

    public boolean getTable() {
        return this.table;
    }

    public Optional<QualifiedName> getTableName() {
        return this.tableName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowGrants(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.tableName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowGrants o = (ShowGrants)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.tableName, o.tableName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("table", this.table).add("tableName", this.tableName).toString();
    }
}

