/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowColumns
extends Statement {
    private final QualifiedName table;

    public ShowColumns(QualifiedName table) {
        this(Optional.empty(), table);
    }

    public ShowColumns(NodeLocation location, QualifiedName table) {
        this(Optional.of(location), table);
    }

    private ShowColumns(Optional<NodeLocation> location, QualifiedName table) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
    }

    public QualifiedName getTable() {
        return this.table;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowColumns(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowColumns o = (ShowColumns)obj;
        return Objects.equals(this.table, o.table);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("table", this.table).toString();
    }
}

