/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.PathSpecification;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SetPath
extends Statement {
    private final PathSpecification pathSpecification;

    public SetPath(PathSpecification pathSpecification) {
        this(Optional.empty(), pathSpecification);
    }

    public SetPath(NodeLocation location, PathSpecification pathSpecification) {
        this(Optional.of(location), pathSpecification);
    }

    private SetPath(Optional<NodeLocation> location, PathSpecification pathSpecification) {
        super(location);
        this.pathSpecification = Objects.requireNonNull(pathSpecification, "path is null");
    }

    public PathSpecification getPathSpecification() {
        return this.pathSpecification;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetPath(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of(this.pathSpecification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pathSpecification);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetPath o = (SetPath)obj;
        return Objects.equals(this.pathSpecification, o.pathSpecification);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("pathSpecification", this.pathSpecification).toString();
    }
}

