/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class QualifiedName {
    private final List<String> parts;
    private final List<String> originalParts;

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first, "first is null");
        return QualifiedName.of(ImmutableList.copyOf(Lists.asList(first, rest)));
    }

    public static QualifiedName of(String name) {
        Objects.requireNonNull(name, "name is null");
        return QualifiedName.of(ImmutableList.of(name));
    }

    public static QualifiedName of(Iterable<String> originalParts) {
        Objects.requireNonNull(originalParts, "originalParts is null");
        Preconditions.checkArgument(!Iterables.isEmpty(originalParts), "originalParts is empty");
        ImmutableList<String> parts = ImmutableList.copyOf(Iterables.transform(originalParts, part -> part.toLowerCase(Locale.ENGLISH)));
        return new QualifiedName(ImmutableList.copyOf(originalParts), parts);
    }

    private QualifiedName(List<String> originalParts, List<String> parts) {
        this.originalParts = originalParts;
        this.parts = parts;
    }

    public List<String> getParts() {
        return this.parts;
    }

    public List<String> getOriginalParts() {
        return this.originalParts;
    }

    public String toString() {
        return Joiner.on('.').join(this.parts);
    }

    public Optional<QualifiedName> getPrefix() {
        if (this.parts.size() == 1) {
            return Optional.empty();
        }
        List<String> subList = this.parts.subList(0, this.parts.size() - 1);
        return Optional.of(new QualifiedName(subList, subList));
    }

    public boolean hasSuffix(QualifiedName suffix) {
        if (this.parts.size() < suffix.getParts().size()) {
            return false;
        }
        int start = this.parts.size() - suffix.getParts().size();
        return this.parts.subList(start, this.parts.size()).equals(suffix.getParts());
    }

    public String getSuffix() {
        return Iterables.getLast(this.parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.parts.equals(((QualifiedName)o).parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

