/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.TableElement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class LikeClause
extends TableElement {
    private final QualifiedName tableName;
    private final Optional<PropertiesOption> propertiesOption;

    public LikeClause(QualifiedName tableName, Optional<PropertiesOption> propertiesOption) {
        this(Optional.empty(), tableName, propertiesOption);
    }

    public LikeClause(NodeLocation location, QualifiedName tableName, Optional<PropertiesOption> propertiesOption) {
        this(Optional.of(location), tableName, propertiesOption);
    }

    private LikeClause(Optional<NodeLocation> location, QualifiedName tableName, Optional<PropertiesOption> propertiesOption) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.propertiesOption = Objects.requireNonNull(propertiesOption, "propertiesOption is null");
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public Optional<PropertiesOption> getPropertiesOption() {
        return this.propertiesOption;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLikeClause(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LikeClause o = (LikeClause)obj;
        return Objects.equals(this.tableName, o.tableName) && Objects.equals(this.propertiesOption, o.propertiesOption);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.propertiesOption);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("tableName", this.tableName).add("propertiesOption", this.propertiesOption).toString();
    }

    public static enum PropertiesOption {
        INCLUDING,
        EXCLUDING;

    }
}

