/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.PrincipalSpecification;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class GrantorSpecification {
    private final Type type;
    private final Optional<PrincipalSpecification> principal;

    public GrantorSpecification(Type type, Optional<PrincipalSpecification> principal) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
    }

    public Type getType() {
        return this.type;
    }

    public Optional<PrincipalSpecification> getPrincipal() {
        return this.principal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantorSpecification that = (GrantorSpecification)o;
        return this.type == that.type && Objects.equals(this.principal, that.principal);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.principal});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("principal", this.principal).toString();
    }

    public static enum Type {
        PRINCIPAL,
        CURRENT_USER,
        CURRENT_ROLE;

    }
}

