/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.GrantorSpecification;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.PrincipalSpecification;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class GrantRoles
extends Statement {
    private final Set<Identifier> roles;
    private final Set<PrincipalSpecification> grantees;
    private final boolean withAdminOption;
    private final Optional<GrantorSpecification> grantor;

    public GrantRoles(NodeLocation location, Set<Identifier> roles, Set<PrincipalSpecification> grantees, boolean withAdminOption, Optional<GrantorSpecification> grantor) {
        this(Optional.of(location), roles, grantees, withAdminOption, grantor);
    }

    public GrantRoles(Set<Identifier> roles, Set<PrincipalSpecification> grantees, boolean withAdminOption, Optional<GrantorSpecification> grantor) {
        this(Optional.empty(), roles, grantees, withAdminOption, grantor);
    }

    private GrantRoles(Optional<NodeLocation> location, Set<Identifier> roles, Set<PrincipalSpecification> grantees, boolean withAdminOption, Optional<GrantorSpecification> grantor) {
        super(location);
        this.roles = ImmutableSet.copyOf((Collection)Objects.requireNonNull(roles, "roles is null"));
        this.grantees = ImmutableSet.copyOf((Collection)Objects.requireNonNull(grantees, "grantees is null"));
        this.withAdminOption = withAdminOption;
        this.grantor = Objects.requireNonNull(grantor, "grantor is null");
    }

    public Set<Identifier> getRoles() {
        return this.roles;
    }

    public Set<PrincipalSpecification> getGrantees() {
        return this.grantees;
    }

    public boolean isWithAdminOption() {
        return this.withAdminOption;
    }

    public Optional<GrantorSpecification> getGrantor() {
        return this.grantor;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGrantRoles(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantRoles grantRoles = (GrantRoles)o;
        return this.withAdminOption == grantRoles.withAdminOption && Objects.equals(this.roles, grantRoles.roles) && Objects.equals(this.grantees, grantRoles.grantees) && Objects.equals(this.grantor, grantRoles.grantor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.roles, this.grantees, this.withAdminOption, this.grantor);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("roles", this.roles).add("grantees", this.grantees).add("withAdminOption", this.withAdminOption).add("grantor", this.grantor).toString();
    }
}

