/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentPath;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.CurrentUser;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class ExpressionTreeRewriter<C> {
    private final ExpressionRewriter<C> rewriter;
    private final AstVisitor<Expression, Context<C>> visitor;

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node) {
        return new ExpressionTreeRewriter<Object>(rewriter).rewrite(node, null);
    }

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node, C context) {
        return new ExpressionTreeRewriter<C>(rewriter).rewrite(node, context);
    }

    public ExpressionTreeRewriter(ExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor();
    }

    private List<Expression> rewrite(List<Expression> items, Context<C> context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : items) {
            builder.add(this.rewrite(expression, context.get()));
        }
        return builder.build();
    }

    public <T extends Expression> T rewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, false));
    }

    public <T extends Expression> T defaultRewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, true));
    }

    private static <T> boolean sameElements(Optional<T> a, Optional<T> b) {
        if (!a.isPresent() && !b.isPresent()) {
            return true;
        }
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        return a.get() == b.get();
    }

    private static <T> boolean sameElements(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (Iterables.size(a) != Iterables.size(b)) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }

    private class RewritingVisitor
    extends AstVisitor<Expression, Context<C>> {
        private RewritingVisitor() {
        }

        @Override
        protected Expression visitExpression(Expression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            throw new UnsupportedOperationException("not yet implemented: " + this.getClass().getSimpleName() + " for " + node.getClass().getName());
        }

        @Override
        protected Expression visitRow(Row node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteRow(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List items = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getItems()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getItems(), items)) {
                return new Row(items);
            }
            return node;
        }

        @Override
        protected Expression visitArithmeticUnary(ArithmeticUnaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticUnary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression child = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (child != node.getValue()) {
                return new ArithmeticUnaryExpression(node.getSign(), child);
            }
            return node;
        }

        @Override
        public Expression visitArithmeticBinary(ArithmeticBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticBinary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ArithmeticBinaryExpression(node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitArrayConstructor(ArrayConstructor node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArrayConstructor(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List values = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getValues()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), values)) {
                return new ArrayConstructor(values);
            }
            return node;
        }

        @Override
        protected Expression visitAtTimeZone(AtTimeZone node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteAtTimeZone(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression timeZone = ExpressionTreeRewriter.this.rewrite(node.getTimeZone(), context.get());
            if (value != node.getValue() || timeZone != node.getTimeZone()) {
                return new AtTimeZone(value, timeZone);
            }
            return node;
        }

        @Override
        protected Expression visitSubscriptExpression(SubscriptExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubscriptExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression base = ExpressionTreeRewriter.this.rewrite(node.getBase(), context.get());
            Expression index = ExpressionTreeRewriter.this.rewrite(node.getIndex(), context.get());
            if (base != node.getBase() || index != node.getIndex()) {
                return new SubscriptExpression(base, index);
            }
            return node;
        }

        @Override
        public Expression visitComparisonExpression(ComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteComparisonExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ComparisonExpression(node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitBetweenPredicate(BetweenPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBetweenPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression min = ExpressionTreeRewriter.this.rewrite(node.getMin(), context.get());
            Expression max = ExpressionTreeRewriter.this.rewrite(node.getMax(), context.get());
            if (value != node.getValue() || min != node.getMin() || max != node.getMax()) {
                return new BetweenPredicate(value, min, max);
            }
            return node;
        }

        @Override
        public Expression visitLogicalBinaryExpression(LogicalBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLogicalBinaryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new LogicalBinaryExpression(node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        public Expression visitNotExpression(NotExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNotExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new NotExpression(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNullPredicate(IsNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNotNullPredicate(IsNotNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNotNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNotNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitNullIfExpression(NullIfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNullIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression first = ExpressionTreeRewriter.this.rewrite(node.getFirst(), context.get());
            Expression second = ExpressionTreeRewriter.this.rewrite(node.getSecond(), context.get());
            if (first != node.getFirst() || second != node.getSecond()) {
                return new NullIfExpression(first, second);
            }
            return node;
        }

        @Override
        protected Expression visitIfExpression(IfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression condition = ExpressionTreeRewriter.this.rewrite(node.getCondition(), context.get());
            Expression trueValue = ExpressionTreeRewriter.this.rewrite(node.getTrueValue(), context.get());
            Expression falseValue = null;
            if (node.getFalseValue().isPresent()) {
                falseValue = ExpressionTreeRewriter.this.rewrite(node.getFalseValue().get(), context.get());
            }
            if (condition != node.getCondition() || trueValue != node.getTrueValue() || falseValue != node.getFalseValue().orElse(null)) {
                return new IfExpression(condition, trueValue, falseValue);
            }
            return node;
        }

        @Override
        protected Expression visitSearchedCaseExpression(SearchedCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSearchedCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add(ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (!ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), builder.build())) {
                return new SearchedCaseExpression((List<WhenClause>)((Object)builder.build()), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitSimpleCaseExpression(SimpleCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSimpleCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add(ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (operand != node.getOperand() || !ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), builder.build())) {
                return new SimpleCaseExpression(operand, (List<WhenClause>)((Object)builder.build()), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitWhenClause(WhenClause node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteWhenClause(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            Expression result2 = ExpressionTreeRewriter.this.rewrite(node.getResult(), context.get());
            if (operand != node.getOperand() || result2 != node.getResult()) {
                return new WhenClause(operand, result2);
            }
            return node;
        }

        @Override
        protected Expression visitCoalesceExpression(CoalesceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCoalesceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List operands = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getOperands()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getOperands(), operands)) {
                return new CoalesceExpression(operands);
            }
            return node;
        }

        @Override
        public Expression visitTryExpression(TryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteTryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getInnerExpression(), context.get());
            if (node.getInnerExpression() != expression) {
                return new TryExpression(expression);
            }
            return node;
        }

        @Override
        public Expression visitFunctionCall(FunctionCall node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFunctionCall(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Optional<Expression> filter = node.getFilter();
            if (filter.isPresent()) {
                Expression filterExpression = filter.get();
                Expression newFilterExpression = ExpressionTreeRewriter.this.rewrite(filterExpression, context.get());
                filter = Optional.of(newFilterExpression);
            }
            Optional<Window> rewrittenWindow = node.getWindow();
            if (node.getWindow().isPresent()) {
                Optional<WindowFrame> rewrittenFrame;
                Window window = node.getWindow().get();
                List partitionBy = ExpressionTreeRewriter.this.rewrite((Expression)((Object)window.getPartitionBy()), (Object)context);
                Optional<OrderBy> orderBy2 = Optional.empty();
                if (window.getOrderBy().isPresent()) {
                    orderBy2 = Optional.of(this.rewriteOrderBy(window.getOrderBy().get(), context));
                }
                if ((rewrittenFrame = window.getFrame()).isPresent()) {
                    Expression rewrittenValue;
                    Optional<Expression> value;
                    Optional<FrameBound> rewrittenEnd;
                    Expression value2;
                    WindowFrame frame = rewrittenFrame.get();
                    FrameBound start = frame.getStart();
                    if (start.getValue().isPresent() && (value2 = ExpressionTreeRewriter.this.rewrite(start.getValue().get(), context.get())) != start.getValue().get()) {
                        start = new FrameBound(start.getType(), value2);
                    }
                    if ((rewrittenEnd = frame.getEnd()).isPresent() && (value = rewrittenEnd.get().getValue()).isPresent() && (rewrittenValue = ExpressionTreeRewriter.this.rewrite(value.get(), context.get())) != value.get()) {
                        rewrittenEnd = Optional.of(new FrameBound(rewrittenEnd.get().getType(), rewrittenValue));
                    }
                    if (frame.getStart() != start || !ExpressionTreeRewriter.sameElements(frame.getEnd(), rewrittenEnd)) {
                        rewrittenFrame = Optional.of(new WindowFrame(frame.getType(), start, rewrittenEnd));
                    }
                }
                if (!(ExpressionTreeRewriter.sameElements(window.getPartitionBy(), partitionBy) && ExpressionTreeRewriter.sameElements(window.getOrderBy(), orderBy2) && ExpressionTreeRewriter.sameElements(window.getFrame(), rewrittenFrame))) {
                    rewrittenWindow = Optional.of(new Window(partitionBy, orderBy2, rewrittenFrame));
                }
            }
            List arguments = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getArguments()), (Object)context);
            if (!(ExpressionTreeRewriter.sameElements(node.getArguments(), arguments) && ExpressionTreeRewriter.sameElements(rewrittenWindow, node.getWindow()) && ExpressionTreeRewriter.sameElements(filter, node.getFilter()))) {
                return new FunctionCall(node.getName(), rewrittenWindow, filter, node.getOrderBy().map(orderBy -> this.rewriteOrderBy((OrderBy)orderBy, context)), node.isDistinct(), arguments);
            }
            return node;
        }

        private OrderBy rewriteOrderBy(OrderBy orderBy, Context<C> context) {
            List<SortItem> rewrittenSortItems = this.rewriteSortItems(orderBy.getSortItems(), context);
            if (ExpressionTreeRewriter.sameElements(orderBy.getSortItems(), rewrittenSortItems)) {
                return orderBy;
            }
            return new OrderBy(rewrittenSortItems);
        }

        private List<SortItem> rewriteSortItems(List<SortItem> sortItems, Context<C> context) {
            ImmutableList.Builder rewrittenSortItems = ImmutableList.builder();
            for (SortItem sortItem : sortItems) {
                Expression sortKey = ExpressionTreeRewriter.this.rewrite(sortItem.getSortKey(), context.get());
                if (sortItem.getSortKey() != sortKey) {
                    rewrittenSortItems.add(new SortItem(sortKey, sortItem.getOrdering(), sortItem.getNullOrdering()));
                    continue;
                }
                rewrittenSortItems.add(sortItem);
            }
            return rewrittenSortItems.build();
        }

        @Override
        protected Expression visitLambdaExpression(LambdaExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLambdaExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression body = ExpressionTreeRewriter.this.rewrite(node.getBody(), context.get());
            if (body != node.getBody()) {
                return new LambdaExpression(node.getArguments(), body);
            }
            return node;
        }

        @Override
        protected Expression visitBindExpression(BindExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBindExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List values = node.getValues().stream().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get())).collect(ImmutableList.toImmutableList());
            Expression function = ExpressionTreeRewriter.this.rewrite(node.getFunction(), context.get());
            if (!ExpressionTreeRewriter.sameElements(values, node.getValues()) || function != node.getFunction()) {
                return new BindExpression(values, function);
            }
            return node;
        }

        @Override
        public Expression visitLikePredicate(LikePredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLikePredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression pattern = ExpressionTreeRewriter.this.rewrite(node.getPattern(), context.get());
            Optional<Expression> rewrittenEscape = node.getEscape().map(escape -> ExpressionTreeRewriter.this.rewrite(escape, context.get()));
            if (value != node.getValue() || pattern != node.getPattern() || !ExpressionTreeRewriter.sameElements(node.getEscape(), rewrittenEscape)) {
                return new LikePredicate(value, pattern, rewrittenEscape);
            }
            return node;
        }

        @Override
        public Expression visitInPredicate(InPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression list = ExpressionTreeRewriter.this.rewrite(node.getValueList(), context.get());
            if (node.getValue() != value || node.getValueList() != list) {
                return new InPredicate(value, list);
            }
            return node;
        }

        @Override
        protected Expression visitInListExpression(InListExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInListExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List values = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getValues()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), values)) {
                return new InListExpression(values);
            }
            return node;
        }

        @Override
        protected Expression visitExists(ExistsPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExists(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression subquery = node.getSubquery();
            if ((subquery = ExpressionTreeRewriter.this.rewrite(subquery, context.get())) != node.getSubquery()) {
                return new ExistsPredicate(subquery);
            }
            return node;
        }

        @Override
        public Expression visitSubqueryExpression(SubqueryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubqueryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitLiteral(Literal node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLiteral(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitParameter(Parameter node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteParameter(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitIdentifier(Identifier node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIdentifier(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitDereferenceExpression(DereferenceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteDereferenceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression base = ExpressionTreeRewriter.this.rewrite(node.getBase(), context.get());
            if (base != node.getBase()) {
                return new DereferenceExpression(base, node.getField());
            }
            return node;
        }

        @Override
        protected Expression visitExtract(Extract node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExtract(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Extract(expression, node.getField());
            }
            return node;
        }

        @Override
        protected Expression visitCurrentTime(CurrentTime node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentTime(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitCast(Cast node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCast(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Cast(expression, node.getType(), node.isSafe(), node.isTypeOnly());
            }
            return node;
        }

        @Override
        protected Expression visitFieldReference(FieldReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFieldReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitSymbolReference(SymbolReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSymbolReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteQuantifiedComparison(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression subquery = ExpressionTreeRewriter.this.rewrite(node.getSubquery(), context.get());
            if (node.getValue() != value || node.getSubquery() != subquery) {
                return new QuantifiedComparisonExpression(node.getOperator(), node.getQuantifier(), value, subquery);
            }
            return node;
        }

        @Override
        public Expression visitGroupingOperation(GroupingOperation node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteGroupingOperation(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentUser(CurrentUser node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentUser(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentPath(CurrentPath node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentPath(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }
    }
}

