/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.CallArgument;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Call
extends Statement {
    private final QualifiedName name;
    private final List<CallArgument> arguments;

    public Call(QualifiedName name, List<CallArgument> arguments) {
        this(Optional.empty(), name, arguments);
    }

    public Call(NodeLocation location, QualifiedName name, List<CallArgument> arguments) {
        this(Optional.of(location), name, arguments);
    }

    public Call(Optional<NodeLocation> location, QualifiedName name, List<CallArgument> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<CallArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCall(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Call o = (Call)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("arguments", this.arguments).toString();
    }
}

