/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.util.Objects;

public final class Varchars {
    private Varchars() {
    }

    public static boolean isVarcharType(Type type) {
        return type instanceof VarcharType;
    }

    public static Slice truncateToLength(Slice slice, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (!Varchars.isVarcharType(type)) {
            throw new IllegalArgumentException("type must be the instance of VarcharType");
        }
        return Varchars.truncateToLength(slice, (VarcharType)VarcharType.class.cast(type));
    }

    public static Slice truncateToLength(Slice slice, VarcharType varcharType) {
        Objects.requireNonNull(varcharType, "varcharType is null");
        return Varchars.truncateToLength(slice, varcharType.getLength());
    }

    public static Slice truncateToLength(Slice slice, int maxLength) {
        Objects.requireNonNull(slice, "slice is null");
        if (maxLength < 0) {
            throw new IllegalArgumentException("Max length must be greater or equal than zero");
        }
        if (maxLength == 0) {
            return Slices.EMPTY_SLICE;
        }
        return slice.slice(0, Varchars.byteCount(slice, 0, slice.length(), maxLength));
    }

    public static int byteCount(Slice slice, int offset, int length, int codePointCount) {
        Objects.requireNonNull(slice, "slice is null");
        if (length < 0) {
            throw new IllegalArgumentException("length must be greater than or equal to zero");
        }
        if (offset < 0 || offset + length > slice.length()) {
            throw new IllegalArgumentException("invalid offset/length");
        }
        if (codePointCount < 0) {
            throw new IllegalArgumentException("codePointsCount must be greater than or equal to zero");
        }
        if (codePointCount == 0) {
            return 0;
        }
        if (codePointCount > length) {
            return length;
        }
        int endIndex = SliceUtf8.offsetOfCodePoint(slice, offset, codePointCount);
        if (endIndex < 0) {
            return length;
        }
        if (offset > endIndex) {
            throw new AssertionError((Object)"offset cannot be smaller than or equal to endIndex");
        }
        return Math.min(endIndex - offset, length);
    }
}

