/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class TypeUtils {
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static Object readNativeValue(Type type, Block block, int position) {
        Class<?> javaType = type.getJavaType();
        if (block.isNull(position)) {
            return null;
        }
        if (javaType == Long.TYPE) {
            return type.getLong(block, position);
        }
        if (javaType == Double.TYPE) {
            return type.getDouble(block, position);
        }
        if (javaType == Boolean.TYPE) {
            return type.getBoolean(block, position);
        }
        if (javaType == Slice.class) {
            return type.getSlice(block, position);
        }
        return type.getObject(block, position);
    }

    public static void writeNativeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, (Boolean)value);
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (type.getJavaType() == Slice.class) {
            Slice slice = value instanceof byte[] ? Slices.wrappedBuffer((byte[])value) : (value instanceof String ? Slices.utf8Slice((String)value) : (Slice)value);
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            type.writeObject(blockBuilder, value);
        }
    }

    static long hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0L;
        }
        return type.hash(block, position);
    }

    static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, errorMsg);
        }
    }
}

