/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractVariableWidthType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collections;
import java.util.Objects;

public final class CharType
extends AbstractVariableWidthType {
    public static final int MAX_LENGTH = 65536;
    private final int length;

    public static CharType createCharType(long length) {
        return new CharType(length);
    }

    private CharType(long length) {
        super(new TypeSignature("char", Collections.singletonList(TypeSignatureParameter.of(length))), Slice.class);
        if (length < 0L || length > 65536L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("CHAR length scale must be in range [0, %s]", 65536));
        }
        this.length = (int)length;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        StringBuilder builder = new StringBuilder(this.length);
        String value = block.getSlice(position, 0, block.getSliceLength(position)).toStringUtf8();
        builder.append(value);
        for (int i = value.length(); i < this.length; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int rightLength;
        int leftLength = leftBlock.getSliceLength(leftPosition);
        if (leftLength != (rightLength = rightBlock.getSliceLength(rightPosition))) {
            return false;
        }
        return leftBlock.equals(leftPosition, 0, rightBlock, rightPosition, 0, leftLength);
    }

    @Override
    public long hash(Block block, int position) {
        return block.hash(position, 0, block.getSliceLength(position));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Slice leftSlice = leftBlock.getSlice(leftPosition, 0, leftBlock.getSliceLength(leftPosition));
        Slice rightSlice = rightBlock.getSlice(rightPosition, 0, rightBlock.getSliceLength(rightPosition));
        return Chars.compareChars(leftSlice, rightSlice);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getSliceLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getSliceLength(position));
    }

    public void writeString(BlockBuilder blockBuilder, String value) {
        this.writeSlice(blockBuilder, Slices.utf8Slice(value));
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length > 0 && value.getByte(offset + length - 1) == 32) {
            throw new IllegalArgumentException("Slice representing Char should not have trailing spaces");
        }
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharType other = (CharType)o;
        return Objects.equals(this.length, other.length);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.length);
    }

    @Override
    public String getDisplayName() {
        return this.getTypeSignature().toString();
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }
}

