/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import java.util.Objects;

public class DoubleRange {
    private final double min;
    private final double max;

    public DoubleRange(double min, double max) {
        if (Double.isNaN(min)) {
            throw new IllegalArgumentException("min must not be NaN");
        }
        if (Double.isNaN(max)) {
            throw new IllegalArgumentException("max must not be NaN");
        }
        if (min > max) {
            throw new IllegalArgumentException(String.format("max must be greater than or equal to min. min: %s. max: %s. ", min, max));
        }
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static DoubleRange union(DoubleRange first, DoubleRange second) {
        Objects.requireNonNull(first, "first is null");
        Objects.requireNonNull(second, "second is null");
        return new DoubleRange(Math.min(first.min, second.min), Math.max(first.max, second.max));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleRange range = (DoubleRange)o;
        return Double.compare(range.min, this.min) == 0 && Double.compare(range.max, this.max) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return "DoubleRange{min=" + this.min + ", max=" + this.max + '}';
    }
}

