/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final List<VariableReferenceExpression> outputVariables;
    private final TupleDomain<ColumnHandle> currentConstraint;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final boolean temporaryTable;

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="assignments") Map<VariableReferenceExpression, ColumnHandle> assignments, @JsonProperty(value="temporaryTable") boolean temporaryTable) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        TableScanNode.checkArgument(assignments.keySet().containsAll(outputVariables), "assignments does not cover all of outputs");
        this.temporaryTable = temporaryTable;
        this.currentConstraint = null;
        this.enforcedConstraint = null;
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments) {
        this(id, table, outputVariables, assignments, TupleDomain.all(), TupleDomain.all(), false);
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint) {
        this(id, table, outputVariables, assignments, currentConstraint, enforcedConstraint, false);
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint, boolean temporaryTable) {
        super(id);
        this.table = Objects.requireNonNull(table, "table is null");
        this.outputVariables = Collections.unmodifiableList(Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = Collections.unmodifiableMap(new HashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        TableScanNode.checkArgument(assignments.keySet().containsAll(outputVariables), "assignments does not cover all of outputs");
        this.currentConstraint = Objects.requireNonNull(currentConstraint, "currentConstraint is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.temporaryTable = temporaryTable;
        if (!currentConstraint.isAll() || !enforcedConstraint.isAll()) {
            TableScanNode.checkArgument(table.getLayout().isPresent(), "tableLayout must be present when currentConstraint or enforcedConstraint is non-trivial");
        }
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonProperty
    public boolean isTemporaryTable() {
        return this.temporaryTable;
    }

    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        TableScanNode.checkState(this.currentConstraint != null, "currentConstraint should only be used in planner. It is not transported to workers.");
        return this.currentConstraint;
    }

    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        TableScanNode.checkState(this.enforcedConstraint != null, "enforcedConstraint should only be used in planner. It is not transported to workers.");
        return this.enforcedConstraint;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append("table='").append(this.table).append('\'');
        stringBuilder.append(", outputVariables='").append(this.outputVariables).append('\'');
        stringBuilder.append(", assignments='").append(this.assignments).append('\'');
        stringBuilder.append(", currentConstraint='").append(this.currentConstraint).append('\'');
        stringBuilder.append(", enforcedConstraint='").append(this.enforcedConstraint).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        TableScanNode.checkArgument(newChildren.isEmpty(), "newChildren is not empty");
        return this;
    }

    private static void checkArgument(boolean test, String errorMessage) {
        if (!test) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void checkState(boolean test, String errorMessage) {
        if (!test) {
            throw new IllegalStateException(errorMessage);
        }
    }
}

