/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public final class TableHandle {
    private final ConnectorId connectorId;
    private final ConnectorTableHandle connectorHandle;
    private final ConnectorTransactionHandle transaction;
    private final Optional<ConnectorTableLayoutHandle> layout;

    @JsonCreator
    public TableHandle(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="connectorHandle") ConnectorTableHandle connectorHandle, @JsonProperty(value="transaction") ConnectorTransactionHandle transaction, @JsonProperty(value="connectorTableLayout") Optional<ConnectorTableLayoutHandle> layout) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.layout = Objects.requireNonNull(layout, "layout is null");
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public ConnectorTableHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    @JsonProperty
    public ConnectorTransactionHandle getTransaction() {
        return this.transaction;
    }

    @JsonProperty
    public Optional<ConnectorTableLayoutHandle> getLayout() {
        return this.layout;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TableHandle)) {
            return false;
        }
        TableHandle other = (TableHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.connectorHandle, other.connectorHandle) && Objects.equals(this.transaction, other.transaction) && Objects.equals(this.layout.isPresent(), other.layout.isPresent());
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.connectorHandle, this.transaction, this.layout);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append("connectorId='").append(this.connectorId).append('\'');
        stringBuilder.append(", connectorHandle='").append(this.connectorHandle).append('\'');
        stringBuilder.append(", layout='").append(this.layout).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

