/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import io.airlift.slice.SizeOf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.openjdk.jol.info.ClassLayout;

public class Page {
    public static final int INSTANCE_SIZE = ClassLayout.parseClass(Page.class).instanceSize() + 2 * ClassLayout.parseClass(AtomicLong.class).instanceSize();
    private final Block[] blocks;
    private final int positionCount;
    private final AtomicLong sizeInBytes = new AtomicLong(-1L);
    private final AtomicLong retainedSizeInBytes = new AtomicLong(-1L);
    private final AtomicLong logicalSizeInBytes = new AtomicLong(-1L);

    public Page(Block ... blocks) {
        this(Page.determinePositionCount(blocks), blocks);
    }

    public Page(int positionCount, Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        this.blocks = Arrays.copyOf(blocks, blocks.length);
        this.positionCount = positionCount;
    }

    public int getChannelCount() {
        return this.blocks.length;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getSizeInBytes() {
        long sizeInBytes = this.sizeInBytes.get();
        if (sizeInBytes < 0L) {
            sizeInBytes = 0L;
            for (Block block : this.blocks) {
                sizeInBytes += block.getSizeInBytes();
            }
            this.sizeInBytes.set(sizeInBytes);
        }
        return sizeInBytes;
    }

    public long getLogicalSizeInBytes() {
        long size = this.logicalSizeInBytes.get();
        if (size < 0L) {
            size = 0L;
            for (Block block : this.blocks) {
                size += block.getLogicalSizeInBytes();
            }
            this.logicalSizeInBytes.set(size);
        }
        return size;
    }

    public long getRetainedSizeInBytes() {
        if (this.retainedSizeInBytes.get() < 0L) {
            this.updateRetainedSize();
        }
        return this.retainedSizeInBytes.get();
    }

    public Block getBlock(int channel) {
        return this.blocks[channel];
    }

    public Page getSingleValuePage(int position) {
        Block[] singleValueBlocks = new Block[this.blocks.length];
        for (int i = 0; i < this.blocks.length; ++i) {
            singleValueBlocks[i] = this.blocks[i].getSingleValueBlock(position);
        }
        return new Page(1, singleValueBlocks);
    }

    public Page getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position %s and length %s in page with %s positions", positionOffset, length, this.positionCount));
        }
        int channelCount = this.getChannelCount();
        Block[] slicedBlocks = new Block[channelCount];
        for (int i = 0; i < channelCount; ++i) {
            slicedBlocks[i] = this.blocks[i].getRegion(positionOffset, length);
        }
        return new Page(length, slicedBlocks);
    }

    public Page appendColumn(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (this.positionCount != block.getPositionCount()) {
            throw new IllegalArgumentException("Block does not have same position count");
        }
        Block[] newBlocks = Arrays.copyOf(this.blocks, this.blocks.length + 1);
        newBlocks[this.blocks.length] = block;
        return new Page(newBlocks);
    }

    public void compact() {
        if (this.getRetainedSizeInBytes() <= this.getSizeInBytes()) {
            return;
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            if (block instanceof DictionaryBlock) continue;
            this.blocks[i] = block.copyRegion(0, block.getPositionCount());
        }
        Map<DictionaryId, DictionaryBlockIndexes> dictionaryBlocks = this.getRelatedDictionaryBlocks();
        for (DictionaryBlockIndexes blockIndexes : dictionaryBlocks.values()) {
            List<DictionaryBlock> compactBlocks = Page.compactRelatedBlocks(blockIndexes.getBlocks());
            List<Integer> indexes = blockIndexes.getIndexes();
            for (int i = 0; i < compactBlocks.size(); ++i) {
                this.blocks[indexes.get((int)i).intValue()] = compactBlocks.get(i);
            }
        }
        this.updateRetainedSize();
    }

    private Map<DictionaryId, DictionaryBlockIndexes> getRelatedDictionaryBlocks() {
        HashMap<DictionaryId, DictionaryBlockIndexes> relatedDictionaryBlocks = new HashMap<DictionaryId, DictionaryBlockIndexes>();
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            if (!(block instanceof DictionaryBlock)) continue;
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            relatedDictionaryBlocks.computeIfAbsent(dictionaryBlock.getDictionarySourceId(), id -> new DictionaryBlockIndexes()).addBlock(dictionaryBlock, i);
        }
        return relatedDictionaryBlocks;
    }

    private static List<DictionaryBlock> compactRelatedBlocks(List<DictionaryBlock> blocks) {
        DictionaryBlock firstDictionaryBlock = blocks.get(0);
        Block dictionary = firstDictionaryBlock.getDictionary();
        int positionCount = firstDictionaryBlock.getPositionCount();
        int dictionarySize = dictionary.getPositionCount();
        int[] dictionaryPositionsToCopy = new int[Math.min(dictionarySize, positionCount)];
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int numberOfIndexes = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = firstDictionaryBlock.getId(i);
            if (remapIndex[position] != -1) continue;
            dictionaryPositionsToCopy[numberOfIndexes] = position;
            remapIndex[position] = numberOfIndexes++;
        }
        if (numberOfIndexes == dictionarySize) {
            return blocks;
        }
        int[] newIds = Page.getNewIds(positionCount, firstDictionaryBlock, remapIndex);
        ArrayList<DictionaryBlock> outputDictionaryBlocks = new ArrayList<DictionaryBlock>(blocks.size());
        DictionaryId newDictionaryId = DictionaryId.randomDictionaryId();
        for (DictionaryBlock dictionaryBlock : blocks) {
            if (!firstDictionaryBlock.getDictionarySourceId().equals(dictionaryBlock.getDictionarySourceId())) {
                throw new IllegalArgumentException("dictionarySourceIds must be the same");
            }
            try {
                Block compactDictionary = dictionaryBlock.getDictionary().copyPositions(dictionaryPositionsToCopy, 0, numberOfIndexes);
                outputDictionaryBlocks.add(new DictionaryBlock(positionCount, compactDictionary, newIds, true, newDictionaryId));
            }
            catch (UnsupportedOperationException e) {
                outputDictionaryBlocks.add(dictionaryBlock);
            }
        }
        return outputDictionaryBlocks;
    }

    private static int[] getNewIds(int positionCount, DictionaryBlock dictionaryBlock, int[] remapIndex) {
        int[] newIds = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int newId = remapIndex[dictionaryBlock.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        return newIds;
    }

    public Page getLoadedPage() {
        boolean allLoaded = true;
        Block[] loadedBlocks = new Block[this.blocks.length];
        for (int i = 0; i < this.blocks.length; ++i) {
            loadedBlocks[i] = this.blocks[i].getLoadedBlock();
            if (loadedBlocks[i] == this.blocks[i]) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return this;
        }
        return new Page(loadedBlocks);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Page{");
        builder.append("positions=").append(this.positionCount);
        builder.append(", channels=").append(this.getChannelCount());
        builder.append('}');
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        return builder.toString();
    }

    private static int determinePositionCount(Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        if (blocks.length == 0) {
            throw new IllegalArgumentException("blocks is empty");
        }
        return blocks[0].getPositionCount();
    }

    public Page getPositions(int[] retainedPositions, int offset, int length) {
        Objects.requireNonNull(retainedPositions, "retainedPositions is null");
        Block[] blocks = new Block[this.blocks.length];
        Arrays.setAll(blocks, i -> this.blocks[i].getPositions(retainedPositions, offset, length));
        return new Page(length, blocks);
    }

    public Page prependColumn(Block column) {
        if (column.getPositionCount() != this.positionCount) {
            throw new IllegalArgumentException(String.format("Column does not have same position count (%s) as page (%s)", column.getPositionCount(), this.positionCount));
        }
        Block[] result = new Block[this.blocks.length + 1];
        result[0] = column;
        System.arraycopy(this.blocks, 0, result, 1, this.blocks.length);
        return new Page(this.positionCount, result);
    }

    private void updateRetainedSize() {
        long retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf(this.blocks);
        for (Block block : this.blocks) {
            retainedSizeInBytes += block.getRetainedSizeInBytes();
        }
        this.retainedSizeInBytes.set(retainedSizeInBytes);
    }

    private static class DictionaryBlockIndexes {
        private final List<DictionaryBlock> blocks = new ArrayList<DictionaryBlock>();
        private final List<Integer> indexes = new ArrayList<Integer>();

        private DictionaryBlockIndexes() {
        }

        public void addBlock(DictionaryBlock block, int index) {
            this.blocks.add(block);
            this.indexes.add(index);
        }

        public List<DictionaryBlock> getBlocks() {
            return this.blocks;
        }

        public List<Integer> getIndexes() {
            return this.indexes;
        }
    }
}

